<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

/**
 * Saturday Drive implementation requires for Stripe Submission
 */
interface Subscription
{
    /**
     * Retrieve Submission for given Id
     *
     * @param string $id
     * @return Subscription
     */
    public function retrieve(string $id): Subscription;

    /**
     * Get default payment method
     *
     * @return string
     */
    public function getDefaultPaymentMethod(): string;

    /**
     * Return customer Id
     *
     * @return string
     */
    public function getCustomerId(): string;

    /**
     * Return object as array
     *
     * @return array
     */
    public function toArray(): array;
}
