<?php 
namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

/**
 * Saturday Drive implementation requirements for PaymentMethod
 */
interface PaymentMethod{

    /**
     * Return PaymentMethod object for given id
     *
     * @param string $id
     * @return PaymentMethod
     */
    public function retrievePaymentMethod(string $id): PaymentMethod;

    /**
     * Return payment method type
     * 
     * @return string
     */
    public function getType( ): string;

    /**
     * Return payment method description
     * Fallback to type if description does not exist
     * 
     * @return string
     */
    public function getDescription( ): string;

    /**
     * Return recordable details about the payment method
     * 
     * @return array
     */
    public function getDetails( ): array;

    /**
     * Return card brand
     *
     * @return string
     */
    public function getCardBrand( ): string;

    /**
     * Return card last four
     *
     * @return string
     */
    public function getCardLastFour( ): string;

    /**
     * Return object as array
     *
     * @return array
     */
    public function toArray( ): array;
}