<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Factories;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\LineItem201501;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\LineItem202208;

/**
 * Construct a LineItem entitie from associative array
 *
 * NOTE that currently there are no line item differences between the two API
 * versions, but both are kept for ease of future addition
 */
class LineItemFactory
{
    public static function create($action_settings, $currency)
    {

        if (isset($action_settings['stripe_product_name']) && 0 < strlen($action_settings['stripe_product_name'])) {
            $name = $action_settings['stripe_product_name'];
        } else {
            $name = 'Ninja Forms Collected Payment';
        }

        $amount = round($action_settings['payment_total'] * 100);

        $lineitem = new LineItem201501($name, $amount, $currency);

        if (isset($action_settings['stripe_product_description']) && 0 < strlen($action_settings['stripe_product_description'])) {
            $lineitem->set_description($action_settings['stripe_product_description']);
        }

        if (isset($action_settings['stripe_product_image']) && 0 < strlen($action_settings['stripe_product_image'])) {
            $lineitem->add_image($action_settings['stripe_product_image']);
        }

        return $lineitem;
    }

    public static function create2208($action_settings, $currency)
    {

        if (isset($action_settings['stripe_product_name']) && 0 < strlen($action_settings['stripe_product_name'])) {
            $name = $action_settings['stripe_product_name'];
        } else {
            $name = 'Ninja Forms Collected Payment';
        }

        $amount = round($action_settings['payment_total'] * 100);

        $lineitem = new LineItem202208($name, $amount, $currency);

        if (isset($action_settings['stripe_product_description']) && 0 < strlen($action_settings['stripe_product_description'])) {
            $lineitem->set_description($action_settings['stripe_product_description']);
        }

        if (isset($action_settings['stripe_product_image']) && 0 < strlen($action_settings['stripe_product_image'])) {
            $lineitem->add_image($action_settings['stripe_product_image']);
        }

        return $lineitem;
    }
}
