<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Subscription as InterfacesSubscription;
use \Stripe\Subscription as StripeSubscription;

class Subscription implements InterfacesSubscription
{
    /** @var StripeSubscription */
    protected $subscription;

    /** @inheritDoc */
    public function retrieve(string $id): Subscription
    {
        $this->subscription = StripeSubscription::retrieve($id);

        return $this;
    }

    /** @inheritDoc */
    public function getDefaultPaymentMethod(): string
    {
        $return = $this->subscription->default_payment_method;

        return $return;
    }

    /** @inheritDoc */
    public function getCustomerId(): string
    {
        $return = $this->subscription->customer;

        return $return;
    }

    /** @inheritDoc */
    public function toArray(): array
    {
        $return = $this->subscription->toArray();

        return $return;
    }
}
