<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\PaymentMethod as InterfacesPaymentMethod;
use \Stripe\PaymentMethod as StripePaymentMethod;

use NinjaForms\StripeCheckout\Common\Traits\Logger;

class PaymentMethod implements InterfacesPaymentMethod
{
    use Logger;


    /** @var StripePaymentMethod */
    protected $paymentMethod;

    /** @inheritDoc */
    public function retrievePaymentMethod(string $id): PaymentMethod
    {
        $this->maybeInitializeLogEntry('Entry Point - '.__FUNCTION__);

        $this->paymentMethod = StripePaymentMethod::retrieve($id);

        $this->supportingData['stripePaymentMethod']=$this->paymentMethod->toArray();
        
        return $this;
    }

    /** @inheritDoc */
    public function getType(): string
    {
        return $this->paymentMethod->type;
    }

    /** @inheritDoc */
    public function getDescription(): string
    {
        $this->maybeInitializeLogEntry('Entry Point - '.__FUNCTION__);
        
        $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
        $type = $this->getType();

        // Card types have a "wallet" setting.
        if( 'card' === $type && ! empty( $this->paymentMethod->card->wallet ) ) {
            $wallet_types = NF_Stripe_Checkout()->config( 'CardWalletTypes' );

            $wallet_type = $this->paymentMethod->card->wallet->type;

            if(isset($wallet_types[ $wallet_type ][ 'description' ])){

                return $wallet_types[ $wallet_type ][ 'description' ];
            }
        }

        if( isset( $types[ $type ] ) && isset( $types[ $type ][ 'description' ] ) ) {
            $type = $types[ $type ][ 'description' ];
        }
        return $type;
    }

    /** @inheritDoc */
    public function getDetails(): array
    {
        $this->maybeInitializeLogEntry('Entry Point - '.__FUNCTION__);

        $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
        $type = $this->getType();
        $response = array(
            'payment_method_type' => $type
        );
        if( in_array( $type, array_keys( $types ) ) && isset( $types[ $type ][ 'response_data' ] ) ) {
            foreach( $types[ $type ][ 'response_data' ] as $detail ) {
                if( 'card' === $type && 'wallet' === $detail ) {
                    $response[ $detail ] = $this->paymentMethod->card->wallet->type;
                    continue 1;
                }
                $response[ $detail ] = $this->paymentMethod->{$type}->{$detail};
            }
        }
        $this->supportingData['getDetailsResponse']=$response;
        
        return $response;
    }

    /** @inheritDoc */
    public function getCardBrand(): string
    {
        if( 'card' !== $this->getType() ) return '';
        return $this->paymentMethod->card->brand;
    }

    /** @inheritDoc */
    public function getCardLastFour(): string
    {
        if( 'card' !== $this->getType() ) return '';
        return $this->paymentMethod->card->last4;
    }

    /** @inheritDoc */
    public function toArray(): array
    {
        return $this->paymentMethod->toArray();
    }

    /**
     * Initialize LogEntryArray if it isn't already
     *
     * @return void
     */
    protected function maybeInitializeLogEntry( string $entryPoint): void
    {
        $backtraceSteps = 5;

        if(!isset($this->logEntryArray)){
            $this->initializeLogEntry($backtraceSteps,$entryPoint);
        }
    }

    public function __destruct()
    {
        $this->finalizeLogEntry();
    }
}
