<?php

if (!defined('ABSPATH'))
    exit;

return apply_filters('nf_helpscout_plugin_settings', array(
    /*
      |--------------------------------------------------------------------------
      | Public API Key
      |--------------------------------------------------------------------------
     */

    'helpscout_api_key' => array(
        'id' => 'helpscout_api_key',
        'type' => 'textbox',
        'label' => __('API Key', 'ninja-forms'),
        'desc' => sprintf(
                __('You can generate this API Key in your Manage/Users section of Help Scout.', 'ninja-forms-helpscout')
        ),
    ),
    'helpscout_client_id' => array(
        'id' => 'helpscout_client_id',
        'type' => 'textbox',
        'label' => __('Client Id', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('Copy/paste client Id from your MyApps account menu', 'ninja-forms-helpscout')
        ),
    ),
    'helpscout_client_secret' => array(
        'id' => 'helpscout_client_secret',
        'type' => 'textbox',
        'label' => __('Client Secret', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('Copy/paste client secret from your MyApps account menu', 'ninja-forms-helpscout')
        ),
    ),
    'helpscout_initiate_authorization' => array(
        'id' => 'helpscout_initiate_authorization',
        'type' => 'html',
        'label' => __('Begin Authorization', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('Click to begin/restart authorization to your Helpscout account', 'ninja-forms-helpscout')
        ),
        'html' => '<span id="helpscout_initiate_oauth"></span>',
    ),
    'helpscout_authcode' => array(
        'id' => 'helpscout_authcode',
        'type' => 'textbox',
        'label' => __('Add Authcode', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('Paste the auth code here and save options; click the Generate Token button that will appear', 'ninja-forms-helpscout')
        ),
    ),
    'helpscout_authcode_grant_url' => array(
        'id' => 'helpscout_authcode_grant_url',
        'type' => 'html',
        'label' => __('Generate tokens', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('After saving a new authorization code, click this button to generate access tokens', 'ninja-forms-helpscout')
        ),
        'html' => '<span id="helpscout_authcodegrant"></span>',
    ),
    'helpscout_refresh_token' => array(
        'id' => 'helpscout_refresh_token',
        'type' => 'html',
        'label' => __('Refresh token', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('This is your latest refresh token', 'ninja-forms-helpscout')
        ),
        'html' => '<span id="helpscout_refresh_token"></span>',
    ),
    'helpscout_access_token' => array(
        'id' => 'helpscout_access_token',
        'type' => 'html',
        'label' => __('Access token', 'ninja-forms-helpscout'),
        'desc' => sprintf(
                __('This is your current access token', 'ninja-forms-helpscout')
        ),
        'html' => '<span id="helpscout_access_token">Access token is generated by the refresh token</span>',
    ),
        ));
