<?php

/**
 * Adds notice nag for user to migrate to OAuth
 *
 * @author stuartlb3
 */
class NF_Helpscout_Admin_Notices
{

    /**
     * Dependency injector
     * @var array
     */
    protected $injector;

    /**
     * Credentials used for authorization
     *
     * @var NF_Helpscout_Authorization_Credentials
     */
    protected $credentials;

    /**
     * Adds notice nag for user to migrate to OAuth
     * 
     * @param array $injector
     */
    public function __construct($injector)
    {
        $this->injector = $injector;

        $this->credentials = $injector[ 'credentials' ];

        add_action('init', array( $this, 'init' ));
    }

    /**
     * Add methods required at init
     * 
     * Calls method to conditionally nag user to authorize if refresh token is 
     * not set
     */
    public function init()
    {
        $conditional = $this->credentials->getRefreshToken();

        if (!$conditional) {

            add_action('nf_admin_notices', array( $this, 'addNoticeFilter' ));
        }
    }

    /**
     * Adds notice to switch to OAuth if client Id is not set
     * @param array $notices
     * @return array
     */
    public function addNoticeFilter($notices)
    {
        $title = __('Attention Helpscout Users - New Authorization Needed', 'ninja-forms-helpscout');
        
        $msg_array = array(
            '<strong>'. __('Helpscout is changing to a new authorization process. ', 'ninja-forms-helpscout').'</strong>',
            '',
            __('To ensure you stay connected, please set up a connected app from your Helpscout dashboard.', 'ninja-forms-helpscout'),
            __('We have step by step documentation to help you through it.'),
            __('Please see the documentation at: ', 'ninja-forms-helpscout'),
            '<a href="https://ninjaforms.com/docs/help-scout/?utm_source=Ninja+Forms+Plugin&utm_medium=Help+Scout+WP+Admin+Notice" target="_blank">https://ninjaforms.com/docs/help-scout/</a>'
        );

        $msg = implode('<br />', $msg_array);

        $notices[ 'helpscout_new_oauth' ] = array(
            'title' => $title,
            'msg' => $msg,
            'int' => 0
        );
        return $notices;
    }

}
