<?php

/**
 * Constants for use throughout extension
 *
 * Set as protected properties; can be modified by using filter
 *
 * @property string $apikey_key  NF settings key for API Key
 * @property string $client_id_key  NF settings key for client Id
 * @property string $client_secret_key  NF settings key for client secret
 * @property string $authcode_key  NF settings key for authorization code
 *
 * @property string $initiate_oauth_url Hard coded initiate OAuth URL
 * @property string $token_url Hard coded auth code grant URL
 *
 * @property string $refresh_token_key WP options table key for refresh token
 * @property string $access_token_key WP options TRANSIENT key for access token
 * @property integer $access_expiry Hard coded expiration for access token
 * 
 * @property string $v1_conversations_endpoint  Endpoint for adding V1 Helpscout conversation
 * @property string $v2_conversations_endpoint  Endpoint for adding V2 Helpscout conversation
 * 
 * @property string $v1_mailboxes_endpoint  Endpoint for getting V1 Helpscout lists
 * @property string $v2_mailboxes_endpoint  Endpoint for getting V2 Helpscout lists
 */
class NF_Helpscout_Admin_Constants
{

    protected $apikey_key = 'helpscout_api_key';
    protected $client_id_key = 'helpscout_client_id';
    protected $client_secret_key = 'helpscout_client_secret';
    protected $authcode_key = 'helpscout_authcode';
    protected $initiate_oauth_url = 'https://secure.helpscout.net/authentication/authorizeClientApplication';
    protected $token_url = 'https://api.helpscout.net/v2/oauth2/token';
    protected $refresh_token_key = 'nf_helpscout_refresh_token';
    protected $access_token_key = 'nf_helpscout_access_token';
    protected $access_expiry = 7200; // actual access token expiry, modify transient to shorten as needed

    protected $v1_conversations_endpoint = 'https://api.helpscout.net/v1/conversations.json';
    protected $v2_conversations_endpoint = 'https://api.helpscout.net/v2/conversations';
    protected $v1_mailboxes_endpoint = 'https://api.helpscout.net/v1/mailboxes.json';
    protected $v2_mailboxes_endpoint = 'https://api.helpscout.net/v2/mailboxes';
    
    
    /**
     * Returns the value of a constant to modify dynamically
     *
     * Applies a filter
     * @param string $property
     * @return mixec
     */

    public function __get($property)
    {
        $value = NULL;

        if (property_exists($this, $property)) {

            $value = apply_filters('nfhelpscoutproperty_' . $property, $this->$property);
        }

        return $value;
    }

}
