<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_ActionNewsletter' )) exit;

/**
 * Class NF_Action_Helpscout
 */
final class NF_Helpscout_Actions_Helpscout extends NF_Helpscout_Actions_NewsletterAbstract
{
    /**
     * @var string
     */
    protected $_name  = 'helpscout';

    /**
     * @var array
     */
    protected $_tags = array();

    /**
     * @var string
     */
    protected $_timing = 'normal';

    /**
     * @var int
     */
    protected $_priority = '10';

    /**
     * Constructor for the Helpscout action class
     * @since 3.0
     */
    public function __construct()
    {
        parent::__construct();

        // Sets the nice name of the HelpScout action.
        $this->_nicename = __( 'Help Scout', 'ninja-forms-helpscout' );

        // Removes list groups setting.
        unset( $this->_settings[ 'helpscoutnewsletter_list_groups' ] );


        add_action( 'admin_init', array( $this, 'init_settings' ) );

        add_action( 'nf_admin_enqueue_scripts', array( $this, 'localize_api' ) );

    }

    /**
     * Merges HelpScout settings into Ninja Forms Settings.
     * @since 3.0
     *
     * @return void
     */
    public function init_settings()
    {
        $settings = NF_Helpscout::config( 'ActionHelpscoutSettings' );

        $this->_settings = array_merge( $this->_settings, $settings );
    }

    /**
     * Localizes the HelpScout API key and sends it to the nfHelpScout endpoint.
     * @since 3.0
     *
     * @return void
     */
    public function localize_api()
    {
        // Looks for an API key and sets variable to false if there is no key present.
        $api_key = Ninja_Forms()->get_setting( 'helpscout_api_key', false );

        // Checks if api_key is empty and sets the value of the key to 0 if it is.
        if( empty( $api_key ) ) {
            $api_key = 0;
        }

        // Localizes the varible and sends it to the endpoint.
        wp_localize_script( 'nf-builder', 'nfHelpScout', array(
            'api_key' => $api_key,
        ) );

        // Outputs a div.
        ?>
        <div id="nfHelpScout"></div>
        <?php
    }

    /**
     * Boiler plate method that is required from the base class.
     * @since 3.0
     *
     * @param $action_settings
     */
    public function save( $action_settings )
    {
    
    }

    /**
     * Runs on form processing and handles all data transfers to the HelpScout API.
     * @since 3.0
     *
     * @param array(nested) $action_settings
     * @param string $form_id
     * @param array(nested) $data
     * @return mixed $data
     */
    public function process( $action_settings, $form_id, $data )
    {
        $response = NF_Helpscout()->send_conversation( $action_settings );
        
        // Checks to see if debug setting is set.
        if( 1 == $action_settings[ 'debug' ] ) {
            // Start building our debug message
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<pre><dl>";
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dt><strong>Response: </strong></dt>";
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dt><strong>Headers: </strong></dt>";

            // Loop over the header responses and out put the values.
            foreach( $response[ 'headers' ] as $key => $value ){
                $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dd>" . $key . " => " . $value . "</dd>";
            }

            // Decode the body of the response.
            $response_body = json_decode( $response[ 'body' ] );

            // Build out the rest of the debug message with the code and error from the body.
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dt><strong>Body: </strong></dt>";
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dd>" . 'code :' . $response_body->code . "</dd>";
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "<dd>" . 'error :' . $response_body->error . "</dd>";
            $data[ 'debug' ][ 'form' ][ 'helpscout_response' ] .= "</dl></pre>";
        }

        // if Response is not 201 throw an error.
        if( ! 201 == $response[ 'response' ][ 'code' ] ) {
            $data[ 'errors' ][ 'form' ] = __( 'Your message was not sent to Helpscout. Please contact the site administrator.',
                'ninja-forms-helpscout' );
        }
        
        return $data;
    }

    /**
     * Gets mailbox lists and populates the list in the action settings.
     * @since 3.0
     *
     * @return array
     */
    public function get_lists()
    {
        return NF_Helpscout()->get_mailbox_list();
    }
}
