

jQuery( document ).ready( function ( $ ) {

    // Settings section textbox inputs
    var client_id_textbox = $( '#ninja_forms\\[helpscout_client_id\\]' );
    var client_secret_textbox = $( "#ninja_forms\\[helpscout_client_secret\\]" );
    var authcode_textbox = $( "#ninja_forms\\[helpscout_authcode\\]" );

    // Entire row selector for settings
    var initiate_authlink_row = $( 'tr#row_ninja_forms\\[helpscout_initiate_authorization\\]' );
    var authcode_row = $( 'tr#row_ninja_forms\\[helpscout_authcode\\]' );
    var authcode_grant_row = $( "tr#row_ninja_forms\\[helpscout_authcode_grant_url\\]" );

    // action buttons
    var initiate_authlink_button = $( "#helpscout_initiate_oauth" );
    var authcode_grant_button = $( "#helpscout_authcodegrant" );

    // spans
    var refresh_token_description = $( "#helpscout_refresh_token_description" );

    // Other values
    var refresh_token = $( "#helpscout_refresh_token" );
    var access_token = $( "#helpscout_access_token" );

    initializeMe();
    /**
     * Hides unused values
     * @returns null
     */
    function initializeMe()
    {
        if ( 0 === authcode_textbox.val().length ) {
            authcode_grant_row.hide();
        }

        // construct authcode link button
        updateInitiateAuthLink();

        showHideAuthlink();
    }

    // change to client id - change query param for endpoint
    client_id_textbox.on( "change", function () {

        updateInitiateAuthLink();
        showHideAuthlink();
        highlightChange( initiate_authlink_row );
        passEvent( 'client_id_change' );
    } );

    // change to client secret
    client_secret_textbox.on( "change", function () {
        passEvent( 'client_secret_change' );
    } );


    // Change to authorization code textbox
    authcode_textbox.on( "change", function () {
        authcodeTextboxChange();
        passEvent( 'authcode_change' );
    } );

    authcode_grant_button.on( "click", function () {
        authcodeGrantClick();
    } );

    /**
     * Updates initiate auth link with changed client id
     * @returns null 
     */
    function updateInitiateAuthLink()
    {
        var client_id = client_id_textbox.val();

        var new_auth_link = "window.open('https://secure.helpscout.net/authentication/authorizeClientApplication?client_id="
                + client_id + "','_blank');";


        initiate_authlink_button.html( '<input type="button" value ="Click to begin/restart authorization to your Helpscout account" id="helpscout_initiate_oauth"/>' );
        initiate_authlink_button.attr( "onClick", new_auth_link );
    }

    function showHideAuthlink()
    {
        var client_id = client_id_textbox.val();

        if ( 0 === client_id.length ) {

            initiate_authlink_row.hide( { } );

            authcode_row.hide( { } );

            return;
        } else {

            initiate_authlink_row.show(  );
            authcode_row.show( );
        }
    }
    /**
     * 
     * @returns null
     */
    function authcodeTextboxChange() {

        if ( 0 === authcode_textbox.val().length ) {
            authcode_grant_row
                    .hide( {
                        'duration': 1000
                    } );
        } else {
            authcode_grant_row.show();
            highlightChange( authcode_grant_row );

        }
    }

    /**
     * Animate row, call AJAX handling for Grant Type Authcode
     * @returns null
     */
    function authcodeGrantClick()
    {
        highlightChange( authcode_grant_row, "LightYellow" );

        passEvent( 'clickedonauthcodegrant' );
    }

    /**
     * Animate row to notify Grant Type Authcode completion
     * @param array response
     * @returns null
     */
    function authcodeGrantClickReturn( response )
    {
        highlightChange( authcode_grant_row, "LightGreen" );

        highlightChange( authcode_row, "LightRed" );

        refresh_token.html( response.refresh_token );
        highlightChange( refresh_token );

        access_token.html( response.access_token );
        highlightChange( access_token );

        authcode_textbox.val( response.authcode );

        authcode_grant_row.hide();

        if ( false !== response.refresh_token ) {
            refresh_token
                    .delay( 2500 )
                    .queue(
                            function ( queued ) {
                                refresh_token
                                        .css( {
                                            'background-color': 'LightGreen'
                                        } );
                                queued();
                            } );
            refresh_token_description.html( 'You have a refresh token and are connected to Helpscout - good job!' );
//            refresh_token_description.html("->"+ response.refresh_token + "<-");
        } else {
            
            refresh_token
                    .delay( 2500 )
                    .queue(
                            function ( queued ) {
                                refresh_token
                                        .css( {
                                            'background-color': 'LightRed'
                                        } );
                                queued();
                            } );
            refresh_token_description.html( 'We encountered a problem generating a refresh token.' );
            refresh_token_description.css( {
                                            'background-color': 'LightYellow'
                                        } );

        }
    }

    /**
     * Animates element upon change
     * 
     * Shows background color briefly, then fades to transparent
     * 
     * @returns null
     */
    function highlightChange( element, color = "LightGreen" )
    {
        element
                .css( {
                    'background-color': color
                } )
                .delay( 2000 )
                .queue(
                        function ( queued ) {
                            element
                                    .css( {
                                        'background-color': 'transparent'
                                    } );
                            queued();
                        } );
    }

    function passEvent( context ) {

        var client_id = client_id_textbox.val();
        var client_secret = client_secret_textbox.val();
        var authcode = authcode_textbox.val();

        var data = {
            action: 'nf_helpscout_oauth',
            client_id: client_id,
            client_secret: client_secret,
            authcode: authcode,
            context: context
        };

        jQuery.post(
                ajaxurl,
                data,
                function ( response ) {

                    switch ( context ) {
                        case 'client_id_change':
                            break;
                        case 'client_secret_change':
                            break;
                        case 'authcode_change':
                            break;
                        case 'clickedonauthcodegrant':
                            authcodeGrantClickReturn( response );
                            break;

                    }

                },
                'json'
                );

    }

} );

