var nfRadio = Backbone.Radio;

// Create a modal view for entering keys
var NFHelpScoutView = Marionette.ItemView.extend({
    // HTML Element
    el: '#nfHelpScout',
    template: '#tmpl-nf-helpscout-modal',

    /**
     * Render view on init.
     * @since 3.0
     *
     * @return void
     */
    initialize: function() {
        this.render();
    },

    // Sets up all events to be listened for.
    events: {
        'click .save'   : 'clickSave',
        'click .cancel' : 'clickCancel',
        'click .close'  : 'clickClose'
    },

    /**
     * Send key to database upon save.
     * @since 3.0
     *
     * @param e
     * @return void
     */
    clickSave: function( e ){

        // Get our API key from the input element.
        var key = jQuery( this.el )
                    .find( '#nf-helpscout-api-input' )
                    .val();

        // Build our data object.
        var data = {
            action: 'nf_helpscout_update_key',
            key: key,
            security: nfAdmin.ajaxNonce
        };

        // Setting context to be used later.
        var that = this;


        jQuery( this.el )
            .find( '.nf-error')
            .html( '' );

        // Disable inputs during save.
        jQuery( this.el )
            .find( 'input' )
            .attr( 'disabled', true )
            .addClass( 'disabled' );

        // Add spinner.
        jQuery( this.el )
            .find( '.spinner' )
            .css( 'visibility', 'visible' );

        // Sends data to the AJAXURL via post method.
        jQuery
            .post(
                ajaxurl,
                data,

                /**
                 * Checks validity of API key and performs action based on result.
                 * @since 3.0
                 *
                 * @param response
                 */
                function( response ) {

                    // If key is valid, then show success message modal.
                    if(  response.valid_key ) {
                        jQuery( '.js-newsletter-list-update' )
                            .click();

                        that.template = '#tmpl-nf-helpscout-modal-success';
                        that.render();

                    // Else show error message
                    } else {
                        // Targets nf-error and displays message.
                        jQuery( that.el )
                            .find( '.nf-error' )
                            .html( response.message );

                        // Shakes the modal.
                        jQuery( '.jBox-container' )
                            .effect( 'shake',{times: 3 }, 850 );
                    }

                    // Removes the disabled state from the input after save.
                    jQuery( that.el )
                        .find( 'input' )
                        .attr( 'disabled', false )
                        .removeClass( 'disabled' );

                    // Hides spinner when not processing.
                    jQuery( that.el )
                        .find( '.spinner' )
                        .css( 'visibility', 'hidden' );
                },
                'json'
        );
    },

    /**
     * Closes modal, Closes drawer, and helpscout remove action.
     * @since 3.0
     *
     * @param e
     * @param el
     * @return void
     */
    clickCancel: function ( e, el ) {
        // Sends request to nfHelpScoutError to close the jBox modal.
        nfRadio.channel( 'nfHelpScout' )
            .request( 'close:modal' );

        // Sends request to nfHelpScoutError to remove action model.
        nfRadio.channel( 'nfHelpScout' )
            .request( 'remove:model' );

        // Request to close drawer.
        nfRadio.channel( 'app' )
            .request( 'close:drawer' );

        // Set our nf-error element to an empty string.
        jQuery( this.el )
            .find( '.nf-error' )
            .html( '' );

        // Set our api-input to an empty string.
        jQuery( this.el )
            .find( '#nf-helpscout-api-input' )
            .val( '' );
    },

    /**
     * Sends request to close modal.
     * @since 3.0
     *
     * @return void
     */
    clickClose: function () {
        // Sends request to nfHelpScoutError to close the jBox modal.
        nfRadio.channel( 'nfHelpScout' )
            .request( 'close:modal' );
    }
});

// New up NFHelpScoutView class.
var nfHelpScoutView = new NFHelpScoutView();

/**
 * Error handling class.
 * @since 3.0
 *
 * @return void
 */
var nfHelpScoutError = Marionette.Object.extend( {
    modal: false,

    /**
     * Inits our class.
     * @since 3.0
     *
     * @return 3.0
     */
    initialize: function() {
        // Listens to the actin channel for a HelpScout action and inits the action model when it gets a reply.
        this.listenTo( nfRadio.channel( 'actions-helpscout' ), 'init:actionModel', this.listenToAction );

        // Sends reply to Close HelpScout modal.
        nfRadio.channel( 'nfHelpScout' )
            .reply( 'close:modal', this.closeModal, this );

        // Sends reply to remove action modal.
        nfRadio.channel( 'nfHelpScout' )
            .reply( 'remove:model', this.removeModel, this );
    },

    /**
     * Listens to the action channel and fires HelpScout API key modal if
     * API keys aren't present.
     * @since 3.0
     *
     * @param object model
     * @return void
     */
    listenToAction: function( model ) {

        // Check if the HelpScout Key is not valid(equals 0)
        if( '0' == nfHelpScout.api_key ) {
            this.modal = new jBox('Modal', {
                closeOnEsc: false,
                closeOnClick: false,
                closeButton: false,
                title: jQuery( '.nfHelpscoutTitle' ),
                content: jQuery( '#nfHelpScout' ),
                zIndex: 999999999,
                onOpen: function() {
                    jQuery( '#nf-helpscout-api-input' ).focus();
                }
            });

            // Open th modal and set the action model ot the model that is passed into the function.
            this.modal.open();
            this.modal.actionModel = model;
        }
    },

    /**
     * Closes modal
     * @since 3.0
     *
     * @return void
     */
    closeModal: function() {
        this.modal
            .close();
    },

    /**
     * Removes action model
     * @since 3.0
     *
     * @return void
     */
    removeModel: function() {
        nfRadio.channel( 'actions' )
            .request( 'delete', this.modal.actionModel );
    }
});

// Fires HelpScout error class on doc.ready
jQuery( document ).ready( function( $ ) {
    new nfHelpScoutError();
});