<?php

if (!defined('ABSPATH'))
    exit;
/**
 * Sections in the CRM for which to build data and create with API requests
 * 
 */
return array(
    'company' => array(
        'wrapper' => 'company',
        'endpoint' => 'companies.json',
        'parent_lookup' => '', //
        'child_link_field' => '',
        'required_fields' => array(
//            'last_name' => 'NinjaFormPlaceholder'
        ),
    ),
    'person' => array(
        'wrapper' => 'person',
        'endpoint' => 'people.json',
        'parent_lookup' => 'company', // module of parent
        'child_link_field' => 'company_id', // field name holding parent id for linking
        'required_fields' => array(
//            'last_name' => 'NinjaFormPlaceholder'
        ),
    ),
    'task' => array(
        'wrapper' => 'calendar_entry',
        'endpoint' => 'calendar_entries.json',
        'parent_lookup' => 'person',
        'child_link_field' => 'association_id',
        'required_fields' => array(
            'type' => 'CalendarTask',
            'association_type' => apply_filters('nfpipelinecrm_set_task_association', 'Person'),
            'name' => 'NinjaFormPlaceholder',
        ),
    ),
    'deal' => array(
        'wrapper' => 'deal',
        'endpoint' => 'deals.json',
        'parent_lookup' => 'person',
        'child_link_field' => 'primary_contact_id',
        'required_fields' => array(
            'name' => 'NinjaFormPlaceholder'
        ),
    ),
    'activity' => array(
        'wrapper' => 'note',
        'endpoint' => 'notes.json',
        'parent_lookup' => 'person',
        'child_link_field' => 'person_id',
        'required_fields' => array(
            'content' => 'NinjaFormPlaceholder'
        ),
    ),
    'person_custom' => array(
        'wrapper'=>'person_custom_field_labels',
        'endpoint' => 'admin/person_custom_field_labels.json',
        'parent_lookup' => '',
        'child_link_field' => '',
        'required_fields' => array()
    ),
    'company_custom' => array(
        'wrapper'=>'company_custom_field_labels',
        'endpoint' => 'admin/company_custom_field_labels.json',
        'parent_lookup' => '',
        'child_link_field' => '',
        'required_fields' => array()
    ),
    'deal_custom' => array(
        'wrapper'=>'deal_custom_field_labels',
        'endpoint' => 'admin/deal_custom_field_labels.json',
        'parent_lookup' => '',
        'child_link_field' => '',
        'required_fields' => array()
    ),
);


