<?php

if (!defined('ABSPATH'))
    exit;
/*
 * $key is a READABLE and unique value that is sent with the form submission
 * It is stored as the "field_map" setting in the field mapping option repeater
 * 
 * 
 * $label is the i10n descriptive version of the field map, used to help the
 * form designer select the desired field map location
 * 
 * $map_instructions is a period-delimited instruction set used to build the
 * Array from which the formatted request is built
 */
return array(
    'None' => array(
        'label' => __('None', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'none',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'FirstName' => array(
        'label' => __('First Name', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.first_name',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'LastName' => array(
        'label' => __('Last Name', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.last_name',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonSummary' => array(
        'label' => __('Person Summary', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.summary',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomePhone' => array(
        'label' => __('Person Home Phone', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_phone',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonMobile' => array(
        'label' => __('Person Mobile Phone', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.mobile',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonPosition' => array(
        'label' => __('Person Position', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.position',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWebsite' => array(
        'label' => __('Person Website', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.website',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonEmail' => array(
        'label' => __('Person Email', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.email',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonEmail2' => array(
        'label' => __('Person Email 2', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.email2',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeEmail' => array(
        'label' => __('Person Home Email', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_email',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonType' => array(
        'label' => __('Person Type', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.type',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkAddress1' => array(
        'label' => __('Person Work Address 1', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_address_1',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkAddress2' => array(
        'label' => __('Person Work Address 2', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_address_2',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkCity' => array(
        'label' => __('Person Work City', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_city',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkState' => array(
        'label' => __('Person Work State', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_state',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkCounty' => array(
        'label' => __('Person Work Country', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_country',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonWorkPostalCode' => array(
        'label' => __('Person Work Postal Code', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.work_postal_code',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeAddress1' => array(
        'label' => __('Person Address 1', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_address_1',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeAddress2' => array(
        'label' => __('Person Home Address 2', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_address_2',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeCity' => array(
        'label' => __('Person Home City', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_city',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeState' => array(
        'label' => __('Person Home State', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_state',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomeCounty' => array(
        'label' => __('Person Home Country', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_country',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonHomePostalCode' => array(
        'label' => __('Person Home Postal Code', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.home_postal_code',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonFacebookURL' => array(
        'label' => __('Person Facebook URL', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.facebook_url',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonLinkedInURL' => array(
        'label' => __('Person Linked In URL', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.linked_in_url',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonTwitter' => array(
        'label' => __('Person Twitter', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.twitter',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonInstantMessage' => array(
        'label' => __('Person Instant Message', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.instant_mesage',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'PersonUnsubscribed' => array(
        'label' => __('Person Unsubscribed (True / False)', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.unsubscribed',
        'request_array_structure' => 'single_element',
        'validation_functions' => array('force_boolean'),
    ),
    'PersonBounced' => array(
        'label' => __('Person Bounced (True / False)', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'person.bounced',
        'request_array_structure' => 'single_element',
        'validation_functions' => array('force_boolean'),
    ),
    'CompanyName' => array(
        'label' => __('Company Name', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.name',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyDescription' => array(
        'label' => __('Company Description', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.description',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyWeb' => array(
        'label' => __('Company Website', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.web',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyAddress1' => array(
        'label' => __('Company Address 1', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.address_1',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyAddress2' => array(
        'label' => __('Company Address 2', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.address_2',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyCity' => array(
        'label' => __('Company City', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.city',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyState' => array(
        'label' => __('Company State', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.state',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyPostalCode' => array(
        'label' => __('Company Postal Code', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.postal_code',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyCountry' => array(
        'label' => __('Company Country', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.country',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyPhone1' => array(
        'label' => __('Company Phone 1', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.phone1',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyPhone2' => array(
        'label' => __('Company Phone 2', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.phone2',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyPhone3' => array(
        'label' => __('Company Phone 3', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.phone3',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'CompanyPhone4' => array(
        'label' => __('Company Phone 4', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'company.phone4',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'DealName' => array(
        'label' => __('Deal Name', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'deal.name',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'DealSummary' => array(
        'label' => __('Deal Summary', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'deal.summary',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'DealExpectedClose' => array(
        'label' => __('Deal Expected Close Date', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'deal.expected_close_date',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(
            'convert_date_interval',
            'format_date',
        ),
    ),
    'DealValue' => array(
        'label' => __('Deal Value', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'deal.value',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(
            'force_float'
        ),
    ),
    'TaskName' => array(
        'label' => __('Task Name', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'task.name',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'TaskDescription' => array(
        'label' => __('Task Description', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'task.description',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'TaskDueDate' => array(
        'label' => __('Task Due Date', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'task.due_date',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(
            'convert_date_interval',
            'format_date',
        ),
    ),
    'NoteTitle' => array(
        'label' => __('Note Title', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'activity.title',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
    'NoteContent' => array(
        'label' => __('Note Content', 'ninja-forms-pipeline-crm'),
        'map_instructions' => 'activity.content',
        'request_array_structure' => 'single_element',
        'validation_functions' => array(),
    ),
);
