<?php

class PipelineBuildFormattedRequest {

    /**
     * Section for which the request is to be made
     * @var string 
     */
    protected $module;

    /**
     * Node name lookup for building the array
     * @var string 
     */
    protected $node_lookup;

    /**
     * Request array for a section
     * @var array 
     */
    protected $module_request;

    /**
     * The JSON array being built
     * @var array 
     */
    protected $json_array;

    /**
     *
     * @var string Final array for communication
     */
    protected $formatted_request_array = array(); // initialize

    /**
     * Given a module name and structure array data, builds the JSON object
     * 
     * Builds only one module's request at a time in case downstream modules
     * need linking id from parent module
     * 
     * @param string $module Name of the Pipeline section
     * @param array $module_request Structured array of the section data to build into JSON object
     */
    public function __construct($module, $module_request) {

        $module_config = NF_PipelineCRM()->get_module_config();
        
        $this->module = $module_config[$module]['wrapper'];

        $this->module_request = $module_request;

        $this->node_lookup = NF_PipelineCRM::config('NodeLookup');

        $this->iterate_section_request();
    }

    protected function iterate_section_request() {

        foreach ($this->module_request as $field_key => $data) {

 
            switch ($field_key) {

                case'custom_multiselect':
                    
                    
                    break;
                
                default:
                    $this->add_single_element_node($field_key, $data);
            }
        }
    }

     protected function add_multicustom_array($field_key, $data) {

        $node_name = $field_key;

        $this->json_array[$this->module][$node_name] = $data;
    }
    
 protected function add_single_element_node($top, $data) {

        $node_name = $top;

        $this->json_array[$this->module][$node_name] = $data;
    }

    /**
     * Returns the API node name for a selected node
     * 
     * Defaults to node if no node name in lookup
     * 
     * @param string $node
     */
    protected function node_lookup($node) {

        if (isset($this->node_lookup[$node])) {

            $node_name = $this->node_lookup[$node];
        } else {

            $node_name = $node;
        }
        return $node_name;
    }

    /**
     * Returns the generated JSON array
     * @return array 
     */
    public function get_json_array() {

        return $this->json_array;
    }

    /**
     * Returns the generated JSON object
     * 
     * @return object 
     */
    public function get_json_request() {

        return json_encode($this->json_array);
    }

}
