<?php


/**
 * Support class is given a string snippet and responds with contextual help
 *
 */
class NF_PipelineCRM_Support {
    
    /**
     * Returns any help message available based on a given string
     * 
     * Returns false as default
     * 
     * @param string $string
     */
    public static function help($string, $detail=''){
        
        $help = false;
        
        switch($string){
            
            case 'is not included in the list':

                $help= sprintf( esc_html__( 'The field - %1$s -you are tring to map has a value that isn\'t allowed.  Please check the form field in the field map and ensure your form field only permits allowed values', 'ninja-forms-pipeline-crm' ), $detail );
                break;
            
            case 'required calendar_entry param is missing':
                
            default:
                
        }
        
        return $help;
    }
}
