<?php

if (!defined('ABSPATH'))
    exit;
/**
 * Adds the CRM's settings and settings groups to the main action setting
 * 
 * 
 */
final class NF_PipelineCRM_Admin_Settings {

    /**
     * Consolidated settings data for output
     * @var array 
     */
    protected $supporting_data;

    /**
     * Configured settings for display on settings page
     * 
     * @var array
     */
    protected $configured_settings;

    /**
     * Configures the plugin settings and formats support data
     * 
     */
    public function __construct() {
        // TODO - change this to static function call
        $this->configured_settings = NF_PipelineCRM()->config('PluginSettings');

        $this->collect_data();

        $this->mark_up_connection_verification();

        $this->mark_up_settings_data();
     
        $this->support_data_display_logic();

        $this->api_test_link();

        $this->refresh_account_data_link();

        add_filter('ninja_forms_plugin_settings', array($this, 'plugin_settings'), 10, 1);
        add_filter('ninja_forms_plugin_settings_groups', array($this, 'plugin_settings_groups'), 10, 1);
    }

    /**
     * Merge this action's settings into main settings
     * 
     * @param array $settings
     * @return array
     */
    public function plugin_settings($settings) {

        $settings[NF_PipelineCRM::SLUG] = $this->configured_settings;

        return $settings;
    }

    /**
     * Merge this action's plugin group into settings groups
     * @param array $groups
     * @return array
     */
    public function plugin_settings_groups($groups) {
        // TODO - change this to static function call
        $groups[NF_PipelineCRM::SLUG] = NF_PipelineCRM()->config('PluginSettingsGroups');

        return $groups;
    }

    /**
     * Retrieve data from sources and consolidate for markup
     * 
     * Simplifies iteration of settings output
     */
    protected function collect_data() {

        $support_data = NF_PipelineCRM()->get_support_data();

        $credential_data = NF_PipelineCRM()->get_credentials(); // holds connection message
        
        $account_data= array(NF_PipelineCRM_Constants::ACCOUNT_DATA=>get_option(NF_PipelineCRM_Constants::ACCOUNT_DATA));

        $this->settings_data = array_merge($support_data, $credential_data,$account_data);
        
    }

    /**
     * Uses markup object to markup support data
     */
    protected function mark_up_settings_data() {

        $markup_array = array(
            NF_PipelineCRM_Constants::FIELD_MAP_DATA,
            NF_PipelineCRM_Constants::REQUEST_ARRAY,
            NF_PipelineCRM_Constants::FORMATTED_REQUEST,
            NF_PipelineCRM_Constants::RESPONSE_SUMMARY,
            NF_PipelineCRM_Constants::FULL_RESPONSE,
            NF_PipelineCRM_Constants::ACCOUNT_DATA,
        );

        foreach ($markup_array as $key) {
            $this->configured_settings[$key]['html'] = NF_PipelineCRM_Markup::markup($key, $this->settings_data[$key]);
        }
    }

    
    /**
     * Display or hide support logic based on advanced command
     */
    protected function support_data_display_logic() {

        NF_PipelineCRM_Functions::add_advanced_command_filters('support');

        $support_mode = apply_filters('nfpipelinecrm_display_support', false);

        if (!$support_mode) {

            $support_mode_settings = array(
                NF_PipelineCRM_Constants::FIELD_MAP_DATA,
                NF_PipelineCRM_Constants::REQUEST_ARRAY,
                NF_PipelineCRM_Constants::FORMATTED_REQUEST,
                NF_PipelineCRM_Constants::FULL_RESPONSE,
            );

            foreach ($support_mode_settings as $setting) {

                unset($this->configured_settings[$setting]);
            }
        }
    }

    /**
     * Returns the listener link to test the API
     */
    protected function api_test_link() {

        $url = home_url() . '/?' . NF_PipelineCRM_Constants::LISTENER_URL . '=' . NF_PipelineCRM_Constants::CONNECTION_TEST;
        $link = '<a id="pipeline-connection-test" href="' . $url . '" class = "button">Click to test your API connection</a>';

        $this->configured_settings[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION]['html'] = $link;
    }

    /**
     * Returns the refresh account data link
     */
    protected function refresh_account_data_link() {

        $url = home_url() . '/?' . NF_PipelineCRM_Constants::LISTENER_URL . '=' . NF_PipelineCRM_Constants::ACCOUNT_DATA_REFRESH;
        $link = '<a id="pipeline-refresh-account-data" href="' . $url . '" class = "button">Click to refresh your account data</a>';

        $this->configured_settings[NF_PipelineCRM_Constants::REFRESH_ACCOUNT]['html'] = $link;
    }

    protected function mark_up_connection_verification() {

        if (!is_array($this->settings_data[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION]) || empty($this->settings_data[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION])) {

            $this->settings_data[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION] = __('No recent communication with your account is recorded.', 'ninja-forms-pipeline-crm')
            ;
        } else {
            $this->settings_data[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION] = implode('<br />', $this->settings_data[NF_PipelineCRM_Constants::CONNECTION_VERIFICATION]);
        }
    }

}

// End Class


