<?php
/**
 * Listener class
 * 
 * Does not call any class methods outside of its own plugin
 * Checks for Ninja_Forms class because point is moot otherwise
 */
class NF_PipelineCRM_Listener {

    /**
     * Listens for GET requests with specific commands
     * 
     * Calls specific functions based on the request made; uses 
     * a switch/case so that only vetted functions are called
     */
    public static function listener() {

        /*
         * Check that Ninja_Forms is loaded, otherwise stop listening
         */
        if (!class_exists('Ninja_Forms') || !class_exists('NF_PipelineCRM')) {

            return;
        }

        $trigger = filter_input(INPUT_GET, NF_PipelineCRM_Constants::LISTENER_URL);

        switch ($trigger) {

            case NF_PipelineCRM_Constants::CONNECTION_TEST:

                self::test_connection();
                break;

            case NF_PipelineCRM_Constants::ACCOUNT_DATA_REFRESH:
                self::refresh_account_data();
                break;

            default:
                break;
        }
    }

    /**
     * Test the connection with a standard request
     */
    public static function test_connection() {

        NF_PipelineCRM::file_include('Comm', 'Create');
        NF_PipelineCRM::file_include('Comm', 'HandleResponse');

        $request = json_encode(NF_PipelineCRM()->config('ConnectionTest'));

        NF_PipelineCRM()->modify_support_data(NF_PipelineCRM_Constants::FORMATTED_REQUEST, array('test'=>$request));
        NF_PipelineCRM()->update_support_data();

        $create_class = NF_PipelineCRM_Constants::CREATE_CLASS;
        
        $create_module = new $create_class('person', $request);
        $full_response = $create_module->get_full_response();

        NF_PipelineCRM()->modify_support_data(NF_PipelineCRM_Constants::FULL_RESPONSE, array('test'=> $full_response));
        NF_PipelineCRM()->update_support_data();

        $response_class = NF_PipelineCRM_Constants::RESPONSE_CLASS;
        
        $processed_response_object = new $response_class('person',$full_response);
        $response_summary = $processed_response_object->get_response_summary();

        NF_PipelineCRM()->modify_support_data(NF_PipelineCRM_Constants::RESPONSE_SUMMARY, array('test'=>$response_summary));
        NF_PipelineCRM()->update_support_data();

        $redirect = admin_url() . 'admin.php?page=nf-settings#' . NF_PipelineCRM::SLUG;

        wp_redirect($redirect);
        exit;
    }

    /**
     * Requests the account data and stores it in the database
     */
    public static function refresh_account_data() {

        NF_PipelineCRM::file_include('Comm', 'GetAccountData');
        NF_PipelineCRM::file_include('Comm', 'HandleResponse');
        
        $module_array = array('person_custom','company_custom','deal_custom');
        
        foreach ($module_array as $module) {

            $account_data_class = NF_PipelineCRM_Constants::ACCOUNT_DATA_CLASS;
            
            $get_module = new $account_data_class($module);
            $response = $get_module->get_full_response();

            $response_class = NF_PipelineCRM_Constants::RESPONSE_CLASS;
            
            $processed_response = new $response_class($module, $response);
             
            $response_array[$module] = json_decode(json_encode($processed_response->get_body_json_data()),true);
        }
        update_option(NF_PipelineCRM_Constants::ACCOUNT_DATA,$response_array);
        
        $redirect = admin_url() . 'admin.php?page=nf-settings#' . NF_PipelineCRM::SLUG;

        wp_redirect($redirect);
        exit;
    }

}

add_action('init', 'NF_PipelineCRM_Listener::listener');
