<?php

/**
 * Constants for use throughout extension
 *
 */
class NF_PipelineCRM_Constants {
    /* -------------------
     * 
     * Authorization and Connectivity
     * 
     * --------------------
     */

    /** Ninja Form setting for API Key */
    const API_KEY = 'nfpipelinecrm_apikey';

    /** Ninja Forms setting to display connection verification link */
    const CONNECTION_VERIFICATION = 'nfpipelinecrm_connection_verification';

    /* ------------------
     * 
     * Listener
     * 
     * ------------------
     */

    /**
     * URL for listening for instructions
     */
    const LISTENER_URL = 'nfpipelinecrm_instructions';

    /**
     * GET value for testing API connection
     */
    const CONNECTION_TEST = 'test-connection';

    /**
     * GET value for refreshing custom fields
     */
    const ACCOUNT_DATA_REFRESH = 'refresh-pipeline-data';


    /* ------------------
     * 
     * Processing
     * 
     * ------------------
     */

    /** Key used for "add to" action */
    const ACTION_KEY = 'addtopipeline';

    
    /** Key for option repeater template */
    const FIELD_MAP_REPEATER_KEY = 'nfpipelinecrm_field_map';

    /**
     * 
     * Called at form processing to manage the processing steps 
     */
    const PROCESS_CLASS = 'PipelineProcessForm';

    /**
     * 
     * Validates any value in and returns value out using static methods
     */
    const VALIDATION_CLASS = 'PipelineValidateFields';

    /**
     * Formats the request array into the JSON request
     */
    const FORMAT_REQUEST_CLASS = 'PipelineBuildFormattedRequest';

    /**
     * Creates an entry in the CRM
     */
    const CREATE_CLASS = 'PipelineCreate';

    /**
     * Retrieves existing account data from CRM
     */
    const ACCOUNT_DATA_CLASS = 'PipelineGetAccountData';

    /**
     * Handle the response the comes back from the CRM
     */
    const RESPONSE_CLASS = 'PipelineHandleResponse';
    const SUPPORT_CLASS = 'NF_PipelineCRM_Support';

    /* -------------------
     * 
     * Settings
     * 
     * -------------------- 
     */

    /** Ninja Forms setting for advanced codes */
    const ADVANCED_CODES_KEY = 'nfpipelinecrm_advanced_codes';

    /** wp_options key for storing support data */
    const SUPPORT_DATA = 'nfpipelinecrm_support_data';

    /** Support data key for submission field map data */
    const FIELD_MAP_DATA = 'nfpipelinecrm_field_map_data';

    /** Support data key for constructed request array */
    const REQUEST_ARRAY = 'nfpipelinecrm_request_array';

    /** Support data key for JSON-formatted request */
    const FORMATTED_REQUEST = 'nfpipelinecrm_formatted_request';

    /** Support data key for full response */
    const FULL_RESPONSE = 'nfpipelinecrm_full_response';

    /** Support data key for response summary */
    const RESPONSE_SUMMARY = 'nfpipelinecrm_response_summary';

    /** Support data key for account data refresh link */
    const REFRESH_ACCOUNT = 'nfpipelinecrm_refresh_account_data';

    /** wp_options key for storing account data */
    const ACCOUNT_DATA = 'nfpipelinecrm_account_data';
    
    

    /* --------------------
     * 
     * API-specific settings
     * 
     * -------------------- 
     */

    /** Date format specified by the CRM */
    const DATE_FORMAT = 'Y-m-d';

    /** Base URL for all standard requests */
    const BASE_URL = 'https://api.pipelinedeals.com/api/v3/';

}
