<?php

if (!defined('ABSPATH') || !class_exists('NF_Abstracts_Action'))
    exit;

final class NF_PipelineCRM_Actions_AddToPipeline extends NF_Abstracts_Action {

    /**
     * @var string
     */
    protected $_name = 'addtopipeline';

    /**
     * @var array
     */
    protected $_tags = array();

    /**
     * @var string
     */
    protected $_timing = 'normal';

    /**
     * @var int
     */
    protected $_priority = '10';

    /**
     *
     * @var array Field map with labels and map instructions
     */
    protected $field_map_array;

    /**
     * Drop down version of field map array for option-repeater
     * @var array 
     */
    protected $field_map_dropdown;

    /**
     * Entry types and the entries that use them in a nested array
     * @var array 
     */
    protected $entry_type;

    /**
     * Drop down version of entry type array for option-repeater
     * @var array 
     */
    protected $entry_type_dropdown;

    /**
     * The custom fields array stored in account data
     * @var array
     */
    protected $custom_fields_array;
    
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();

        $this->_nicename = __('Add To Pipeline', 'ninja-forms-pipeline-crm');

        $this->initialize_variables();

        $this->build_custom_field_array();
        
        $this->build_field_map_dropdown();

        $this->build_entry_type_dropdown();

        add_action('admin_init', array($this, 'build_admin_settings'));

        add_action('ninja_forms_builder_templates', array($this, 'builder_templates'));
    }

    /**
     * Configure required settings
     */
    protected function initialize_variables() {

        // configure lookup list of fields to extract from form submission data
        $this->field_map_array = NF_PipelineCRM()->get_field_map_array();

        // configure entry type
        $this->entry_type = NF_PipelineCRM()->get_entry_type();

    }

    public function builder_templates() {

        NF_PipelineCRM::template('custom-field-map-row.html');
    }

    /**
     * Build admin settings that need to be constructed instead of configured
     * 
     * Drop down selector for field map is constructed because the full array
     * for the field map includes both readable names and mapping instructions
     * and thus can't be simply configured with a formatted array
     */
    public function build_admin_settings() {

        // configure array of action settings
        $settings = NF_PipelineCRM::config('ActionFieldMapSettings');

        $this->_settings = array_merge($this->_settings, $settings);

        // build drop down lists for field map
        $this->_settings[NF_PipelineCRM_Constants::FIELD_MAP_REPEATER_KEY]['columns']['field_map']['options'] = $this->field_map_dropdown;

    }

    /*
     * PUBLIC METHODS
     */

    public function save($action_settings) {
        
    }

    public function process($action_settings, $form_id, $data) {

        NF_PipelineCRM::file_include('Comm', 'ProcessForm');

        $process_form_object = NF_PipelineCRM_Functions::get_alternate_process_value('form_processing');

        new $process_form_object($action_settings, $form_id, $data);

        return $data;
    }

    /**
     * Formats an option array for the drop down menu in the option repeater
     * 
     * 
     * @param array $field_map_array
     * @return array
     */
    protected function build_field_map_dropdown() {

        foreach ($this->field_map_array as $key => $label_map_array) {

            $this->field_map_dropdown[] = array(
                'label' => $label_map_array['label'],
                'value' => $key,
            );
        }
        
        if($this->custom_fields_array){

            foreach($this->custom_fields_array as $custom_field){
            
                $this->field_map_dropdown[]=array(
                    'label'=> $custom_field['custom_field']['name'],
                    'value'=>(string)$custom_field['custom_field']['id'],
                );
            }
        }
    }

    /**
     * Build the entry type dropdown for the option repeater
     * 
     * Uses only the array keys from the list
     */
    protected function build_entry_type_dropdown() {

        $this->entry_type_dropdown = array(); // initialize

        $array_keys = array_keys($this->entry_type);

        foreach ($array_keys as $key) {

            $this->entry_type_dropdown[] = array(
                'label' => $key,
                'value' => $key,
            );
        }
    }

    // TODO: Move this someplace shared and build custom fields into array structure similar to field map array
    // TODO: Clean up code after re-testing
    protected function build_custom_field_array(){
                     
        $temp = get_option(NF_PipelineCRM::SLUG.'_account_data');
       /* 
        if(!empty($temp['person_custom'])){
            
            $this->custom_fields_array=$temp['custom_fields']['custom_fields'];
        }else{
            $this->custom_fields_array= array();
        }
        * 
        */
    }
}
