<?php
// @codeCoverageIgnoreStart
if (!defined('ABSPATH')){
    exit;
}
// @codeCoverageIgnoreEnd

/*
  Plugin Name: Ninja Forms - Elavon Payment Gateway
  Plugin URI: http://lb3computingsolutions.com
  Description: Add the Elavon payment gateway to process credit cards through your Ninja Forms
  Author: Stuart Sequeira
  Author URI: http://lb3computingsolutions.com/about/
  Version: 3.1.2
  Text Domain: ninja-forms-elavon-payment-gateway
  Domain Path: /lang/
 */

// @codeCoverageIgnoreStart
    // define  mode as POST3
    if (!defined('NFELAVON_MODE')) {

        define('NFELAVON_MODE', 'POST3');
    }

    // plugin folder url
    if (!defined('NFELAVON_PLUGIN_URL')) {
        define('NFELAVON_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

// plugin folder path
    if (!defined('NFELAVON_PLUGIN_DIR')) {
        define('NFELAVON_PLUGIN_DIR', plugin_dir_path(__FILE__));
    }

    /*
     * Include class files
     */
    include 'includes/Helper/Constants.php';
    include 'includes/Helper/Functions.php';
    include 'includes/Helper/Support.php';
    include 'includes/Helper/Listener.php';   
    include 'includes/Helper/Markup.php';
    include 'includes/Helper/CommLog.php';
    include 'includes/Helper/Auth.php';
    include 'includes/Helper/ValidateFields.php';

    // @codeCoverageIgnoreEnd

    /**
     * Class
     */
    final class NF_Elavon {

        const VERSION = '3.1.2';
        const SLUG = 'nfelavon';
        const NAME = 'Elavon';
        const AUTHOR = 'Stuart Sequeira';
        const PREFIX = 'NF_Elavon';
        const DOMAIN = 'ninja-forms-elavon-payment-gateway';

        /**
         * @var 
         * @since 3.0
         */
        private static $instance;

        /**
         * Plugin Directory
         *
         * @since 3.0
         * @var string $dir
         */
        public static $dir = '';

        /**
         * Plugin URL
         *
         * @since 3.0
         * @var string $url
         */
        public static $url = '';

        /**
         * Credentials stored in the db as a NF setting
         * 
         * @var array 
         */
        protected $credentials;

        /**
         * Support data stored in the db as a WP option
         * 
         * @var array 
         */
        protected $support_data;

        /**
         * Advanced codes array
         * @var array 
         */
        protected $advanced_codes;

        /**
         * Configuration array for field mapping
         * 
         * @var array 
         */
        protected $field_map_array;

        /**
         * List of all entry types with nested array of accepted fields for use
         * @var array
         */
        protected $entry_type;

        /**
         * Module configuration defining structure for communication with the gateway
         * @var array
         */
        protected $module_config;

        /**
         * Array of stored configuration files for reuse
         * 
         * @var array
         */
        protected $stored_config;
        
        /**
         * Main Plugin Instance
         *
         * Insures that only one instance of a plugin class exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @since 3.0
         * @static
         * @static var array $instance
         * @return Highlander Instance
         */
        public static function instance() {

            if (!isset(self::$instance) && !(self::$instance instanceof NF_Elavon)) {
                self::$instance = new NF_Elavon();

                self::$dir = plugin_dir_path(__FILE__);

                self::$url = plugin_dir_url(__FILE__);

                /*
                 * Register our autoloader
                 */
                spl_autoload_register(array(self::$instance, 'autoloader'));
            }

            return self::$instance;
        }

        public function __construct() {
            /*
             * load the global variables
             * do this internally and make available?
             */

            $this->load_config_variables();

            add_action('plugins_loaded', array($this, 'extract_support_data'));

            add_action('admin_init', array($this, 'setup_license'));

            add_action('ninja_forms_loaded', array($this, 'extract_credentials'));
            
            add_action('ninja_forms_loaded', array($this, 'setup_admin'));

            add_filter( 'ninja_forms_register_actions', array( $this, 'register_actions' ) );

            add_filter('ninja_forms_register_payment_gateways', array($this, 'register_payment_gateways'));
                        
            add_filter( 'ninja_forms_enable_credit_card_fields', '__return_true' );
        }

        /**
         * Loads configured settings easy access
         */
        public function load_config_variables() {

            $this->field_map_array= self::config('FieldMapArray');
        }

        /**
         * Registers payment gateway
         * 
         * @codeCoverageIgnore
         * @param array $payment_gateways
         * @return \NF_Elavon_PaymentGateway
         */
        public function register_payment_gateways($payment_gateways) {
            // match slug from payment gateway action
            $payment_gateways[NF_Elavon_Constants::ACTION_KEY] = new NF_Elavon_PaymentGateway();

            return $payment_gateways;
        }

    /**
     * Register Elavon action
     *
     * @param array $actions
     * @return array $actions
     * 
     * @codeCoverageIgnore
     */
    public function register_actions($actions)
    {
        // Create new Authorize.net Action separate from Collect Payment action
        $authorize_action = new \NF_Actions_CollectPayment(
            __('Elavon', 'ninja-forms'),
            'elavon'
        );

        $actions['elavon'] = $authorize_action;

        return $actions;
    }

        /**
         * Set up the licensing
         * @codeCoverageIgnore
         */
        public function setup_license() {

            if (!class_exists('NF_Extension_Updater'))
                return;

            new NF_Extension_Updater(self::NAME, self::VERSION, self::AUTHOR, __FILE__, self::SLUG);
        }

        /**
         * Create the settings page
         * 
         * Hooked into Ninja Forms Loaded
         * 
         * @codeCoverageIgnore
         */
        public function setup_admin() {

            Ninja_Forms()->merge_tags[ 'elavon' ] = new NF_Elavon_MergeTags();
            
            if (!is_admin()){
                
                return;
            }
            // continue for admin pages only
            new NF_Elavon_Admin_Settings();
        }

        /**
         * @todo maybe delete
         *
         * @return void
         * 
         * @codeCoverageIgnore
         */
        public function load_classes() {
            
        }

        /**
         * Returns a configuration specified in a given Config file
         * @param string $file_name
         * @return mixed
         */
        public static function config($file_name) {

            return include self::$dir . 'includes/Config/' . $file_name . '.php';
        }

                
        /**
         * Checks for config already in instance, configs if not, returns
         * @param string $file_name
         * @return array
         */
        public function config_once($file_name) {

            if(!isset($this->stored_config[$file_name])){
                
                $this->stored_config[$file_name]= include self::$dir . 'includes/Config/' . $file_name . '.php';
            }
            
            return  $this->stored_config[$file_name];        
        }
        
        
        /**
         * Includes a specific file in an Includes directory
         * 
         * @param string $sub_dir
         * @param string $file_name
         */
        public static function file_include($sub_dir, $file_name) {

            include_once self::$dir . 'includes/' . $sub_dir . '/' . $file_name . '.php';
        }

        /**
         * Creates a template for display
         * 
         * @param string $file_name
         * @param array $data
         * @return mixed
         */
        public static function template($file_name = '', array $data = array()) {

            if (!$file_name) {
                return;
            }
            extract($data);

            include self::$dir . 'includes/Templates/' . $file_name;
        }

        public function autoloader($class_name) {

            if (class_exists($class_name))
                return;

            if (false === strpos($class_name, self::PREFIX))
                return;

            $class_name = str_replace(self::PREFIX, '', $class_name);
            $classes_dir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR;
            $class_file = str_replace('_', DIRECTORY_SEPARATOR, $class_name) . '.php';

            if (file_exists($classes_dir . $class_file)) {
                require_once $classes_dir . $class_file;
            }
        }

        /**
         * Retrieves Username and Password from settings, sets 'valid' to FALSE if invalid
         */
        public function extract_credentials() {

            $this->credentials['valid'] = true; // initialize

            if (!class_exists('Ninja_Forms')) {

                $this->credentials['valid'] = false;
                $this->credentials[NF_Elavon_Constants::MERCHANT_ID] = '';
                $this->credentials[NF_Elavon_Constants::USER_ID] = '';
                $this->credentials[NF_Elavon_Constants::PIN] = '';
                $this->credentials['connection_message'] = __('Ninja Forms is not present','ninja-forms-elavon-payment-gateway');
                return;
            }

            $this->credentials[NF_Elavon_Constants::MERCHANT_ID] = Ninja_Forms()->get_setting(NF_Elavon_Constants::MERCHANT_ID);
            $this->credentials[NF_Elavon_Constants::USER_ID] = Ninja_Forms()->get_setting(NF_Elavon_Constants::USER_ID);
            $this->credentials[NF_Elavon_Constants::PIN] = Ninja_Forms()->get_setting(NF_Elavon_Constants::PIN);

            if (
                    0 == strlen($this->credentials[NF_Elavon_Constants::MERCHANT_ID]) ||
                    0 == strlen($this->credentials[NF_Elavon_Constants::USER_ID]) ||
                    0 == strlen($this->credentials[NF_Elavon_Constants::PIN])
            ) {
                $this->credentials['connection_message'] = __('Elavon account credentials is not complete.','ninja-forms-elavon-payment-gateway');
                $this->credentials['valid'] = false;
            }

        }

        /** 
         * Extracts support data for use throughout 
         * 
         */
        public function extract_support_data() {

            $settings_default_config = self::config('SupportData');

            $stored_support_data = get_option(NF_Elavon_Constants::SUPPORT_DATA);

            foreach ($settings_default_config as $key => $settings) {

                if (!isset($stored_support_data[$key])) {

                    $stored_support_data[$key] = $settings_default_config[$key]['default'];
                }
            }

            $this->support_data = $stored_support_data;
        }



        /**
         * Returns the support data stored in the db
         * 
         * @return array 
         */
        public function get_support_data() {

            if (empty($this->support_data)) {

                return false;
            } else {

                return $this->support_data;
            }
        }

        /**
         * Returns the credentials for the account
         * 
         * Initialized to an array, 'valid' is set to false if any value is invalid
         * 
         * @return array 
         */
        public function get_credentials() {

            return $this->credentials;
        }


        /**
         * Returns the configured field map array
         * 
         * @return array
         */
        public function get_field_map_array() {

            if (empty($this->field_map_array)) {

                return array();
            } else {

                return $this->field_map_array;
            }
        }

    }

    /**
     * The main function responsible for returning The Highlander Plugin
     * Instance to functions everywhere.
     *
     * Use this function like you would a global variable, except without needing
     * to declare the global.
     *
     * @since 3.0
     * @return {class} Highlander Instance
     * 
     * @codeCoverageIgnore
     */
    function NF_Elavon() {
        return NF_Elavon::instance();
    }

    NF_Elavon();


