<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_Stripe_MergeTags
 */
final class NF_Elavon_MergeTags extends NF_Abstracts_MergeTags
{
    protected $id = 'elavon';

    public function __construct()
    {
        parent::__construct();
        $this->title = __( 'Elavon', 'ninja-forms' );
        $this->merge_tags = NF_Elavon()->config( 'MergeTags' );
    }

    public function __call($name, $arguments)
    {
        // If the mergetag property is not set, then return an empty string.
        return ( isset( $this->$name ) ) ? $this->$name : '';
    }

    public function set( $property, $value )
    {
        $this->$property = $value;
    }

    
    public function html_receipt(){
        
        return NF_Elavon_Constants::HTML_RECEIPT_FIELD_KEY;
    }
    
     public function plaintext_receipt(){
        
        return NF_Elavon_Constants::PLAINTEXT_RECEIPT_FIELD_KEY;
    }   
    
    public function transaction_id(){
        
        return NF_Elavon_Constants::TXN_ID_FIELD_KEY;
    } 
}
