<?php

/**
 * Given context, search help configuration and returns contextual help
 *
 */
class NF_Elavon_Support {

    /**
     * Array of configured contextual help
     *
     * @var array
     */
    protected $help_config_array = array();

    /**
     * String for which support documentation is searched and returned
     *
     * @var string
     */
    protected $context = 'No Context Set';

    public function __construct() {

        $this->help_config_array = NF_Elavon::config('ContextualHelp');
    }

    /**
     * Sets context and returns contextual help array
     *
     * @param string $context
     * @return array
     */
    public function set_and_search_context($context) {

        $this->context = $context;

        $contextual_help_array = $this->search_context();

        return $contextual_help_array;
    }

    /**
     * Searches for context in help configuration and returns array of help text
     *
     * Context should be set before using this method
     *
     * @return array
     */
    public function search_context() {

        $contextual_help_array = array();

        foreach ($this->help_config_array as $search_string => $help_array) {

            if (stripos($this->context, $search_string) === false) {

                continue;
            }

            if (isset($help_array['help_text']) && !empty($help_array['help_text'])) {

                $contextual_help_array = $help_array['help_text'];
                break;
            }
        }

        return $contextual_help_array;
    }

    /**
     * Set context of what support is needed
     *
     * A string is given and it is used to search for available help
     * documentation.
     * @param string $context
     */
    public function set_context($context) {

        $this->context = $context;
    }

}
