<?php

/**
 * Listener class
 * 
 * Does not call any class methods outside of its own plugin
 * Checks for Ninja_Forms class because point is moot otherwise
 */
class NF_Elavon_Listener {

    /**
     * Listens for GET requests with specific commands
     * 
     * Calls specific functions based on the request made; uses 
     * a switch/case so that only vetted functions are called
     */
    public static function listener() {

        /*
         * Check that Ninja_Forms is loaded, otherwise stop listening
         */
        if (!class_exists('Ninja_Forms') || !class_exists('NF_Elavon')) {

            return;
        }

        $trigger = filter_input(INPUT_GET, NF_Elavon_Constants::LISTENER_URL);

        switch ($trigger) {

            case NF_Elavon_Constants::CONNECTION_TEST:

                self::test_connection();
                break;

            case NF_Elavon_Constants::ACCOUNT_DATA_REFRESH:
                self::refresh_account_data();
                break;

            default:
                break;
        }
    }

    /**
     * Test the connection with a standard request
     */
    public static function test_connection() {



        $redirect = admin_url() . 'admin.php?page=nf-settings#' . NF_Elavon::SLUG;

        wp_redirect($redirect);
        exit;
    }

    /**
     * Requests the account data and stores it in the database
     */
    public static function refresh_account_data() {

        $redirect = admin_url() . 'admin.php?page=nf-settings#' . NF_Elavon::SLUG;

        wp_redirect($redirect);
        exit;
    }

}

add_action('init', 'NF_Elavon_Listener::listener');
