<?php

/**
 * Constants for use throughout extension
 *
 */
class NF_Elavon_Constants {
    /* -------------------
     * 
     * Authorization and Connectivity
     * 
     * --------------------
     */

    /*
     * Ninja Form setting for account authorization 
     */

    const MERCHANT_ID = 'nfelavon_merchant_id';
    const USER_ID = 'nfelavon_user_id';
    const PIN = 'nfelavon_pin';

    /** NF setting key for Request Mode (e.g. Production, Demo ) */
    const REQUEST_MODE = 'nfelavon_request_mode';

    /** Settings value for production mode */
    const PRODUCTION_MODE = 'production';

    /** Settings value for demo mode */
    const DEMO_MODE = 'demo';

    /** Credentials are either not present or couldn't be retrieved */
    const CREDENTIALS_INCOMPLETE = 'credentials_incomplete';

    /** Credentials have been retrieved, not necessarily confirmed by API */
    const CREDENTIALS_COMPLETE = 'credentials_complete';

    /** Ninja Forms setting to display connection verification link */
    const CONNECTION_VERIFICATION = 'nfelavon_connection_verification';

    /* ------------------
     * 
     * Listener
     * 
     * ------------------
     */

    /**
     * URL for listening for instructions
     */
    const LISTENER_URL = 'nfelavon_instructions';

    /**
     * GET value for testing API connection
     */
    const CONNECTION_TEST = 'test-connection';

    /**
     * GET value for refreshing custom fields
     */
    const ACCOUNT_DATA_REFRESH = 'refresh-elavon-data';


    /* ------------------
     * 
     * Processing
     * 
     * ------------------
     */

    /** Key used for "Payment Gateway" action */
    const ACTION_KEY = 'elavon';

    /** Key for option repeater template */
    const FIELD_MAP_REPEATER_KEY = 'nfelavon_field_map';

    /** Field key where HTML receipt will be stored */
    const HTML_RECEIPT_FIELD_KEY = '{elavon:html_receipt}';
    
    /** Field key where plain text receipt will be stored */
    const PLAINTEXT_RECEIPT_FIELD_KEY = '{elavon:plaintext_receipt}';
    
    /** Field key where transaction ID will be stored */
    const TXN_ID_FIELD_KEY = '{elavon:txn_id}';
    
    /** Called at form processing to manage the processing steps */
    const PROCESS_CLASS = 'ElavonProcessForm';

    /** Validates any value in and returns value out using static methods */
    const VALIDATION_CLASS = 'ElavonValidateFields';

    /**
     * Processes the payment
     */
    const CREATE_CLASS = 'ElavonProcessPayment';

    /**
     * Retrieves existing account data from the payment processor
     */
    const ACCOUNT_DATA_CLASS = 'ElavonGetAccountData';

    /**
     * Handle the response the comes back from the CRM
     */
    const RESPONSE_CLASS = 'ElavonHandleResponse';
    const SUPPORT_CLASS = 'NF_Elavon_Support';

    /* -------------------
     * 
     * Settings
     * 
     * -------------------- 
     */

    /** Ninja Forms setting for advanced codes */
    const ADVANCED_CODES_KEY = 'nfelavon_advanced_codes';

    /** wp_options key for storing support data */
    const SUPPORT_DATA = 'nfelavon_support_data';

    /** Support data key for submission field map data */
    const FIELD_MAP_DATA = 'nfelavon_field_map_data';

    /** Support data key for constructed request array */
    const REQUEST_ARRAY = 'nfelavon_request_array';

    /** Support data key for full response */
    const FULL_RESPONSE = 'nfelavon_full_response';

    /** Support data key for response summary */
    const RESPONSE_SUMMARY = 'nfelavon_response_summary';

    /** Support data key for account data refresh link */
    const REFRESH_ACCOUNT = 'nfelavon_refresh_account_data';

    /** wp_options key for storing account data */
    const ACCOUNT_DATA = 'nfelavon_account_data';

    /*
     * SUPPORT CODE TAGS 
     */
    /** Support code tag where action is required */
    const ACTION_REQUIRED = '<- Action Required ->';

    /** Support code tag to highlight helpful information */
    const HELPFUL_HINT = '<- Helpful Hint ->';

    /** Support code tag to notify of success */
    const SUCCESS = '<- Success ->';

    /* --------------------
     * 
     * API-specific settings
     * 
     * -------------------- 
     */

    /** Date format specified by the CRM */
    const DATE_FORMAT = 'Y-m-d';

}
