<?php

if (!defined('ABSPATH'))
    exit;
/*
 * $key is a READABLE and unique value that is sent with the form submission
 * It is stored as the "field_map" setting in the field mapping option repeater
 * 
 * 
 * $label is the i10n descriptive version of the field map, used to help the
 * form designer select the desired field map location
 * 
 * $map_instructions is an instruction set used to build the
 * Array from which the formatted request is built
 */
return array(
    'None' => array(
        'label' => __('None', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'none',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    /*
      'CardholderZip' => array(
      'label' => __('Cardholder Zip Code', 'ninja-forms-elavon-payment-gateway'),
      'map_instructions' => 'ssl_avs_zip',
      'request_array_structure' => 'none',
      'validation_functions' => array(),
      ),
      'CVV' => array(
      'label' => __('CVV', 'ninja-forms-elavon-payment-gateway'),
      'map_instructions' => 'ssl_cvv2cvc2',
      'request_array_structure' => 'none',
      'validation_functions' => array(),
      ),
     * 
     */
    'CardholderAddress' => array(
        'label' => __('Cardholder Address', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_avs_address',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'InvoiceNumber' => array(
        'label' => __('Invoice Number', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_invoice_number',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'CustomerCode' => array(
        'label' => __('Customer Code', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_customer_code',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'SalesTax' => array(
        'label' => __('Sales Tax', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_salestax',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'DBAName' => array(
        'label' => __('DBA Name', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_dynamic_dba',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'TransactionCurrency' => array(
        'label' => __('Transaction Currency', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_transaction_currency',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'FirstName' => array(
        'label' => __('First Name', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_first_name',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    'LastName' => array(
        'label' => __('Last Name', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_last_name',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
    /*
    'Amount' => array(
        'label' => __('Amount', 'ninja-forms-elavon-payment-gateway'),
        'map_instructions' => 'ssl_amount',
        'request_array_structure' => 'none',
        'validation_functions' => array(),
    ),
     * 
     */
);
