<?php

/**
 * Returns array of contextual help data
 *
 * [search_string] =>
 *      'help_text'=>
 *          [help text]
 *          [help text]
 */
return apply_filters('nfelavon_filter_contextual_help', array(
    /*
     * The credentials in the settings section is missing some or all of the
     * values required for authorization
     */
    'Elavon account credentials are missing or incomplete' => array(
        'help_text' => array(
            __('1. Please add your Merchant ID, User ID, and PIN credentials and click Save', 'ninja-forms-elavon-payment-gateway'),
            __('2. Please check that your credentials are valid for the mode, either -Demo- or -Production- that your are using.', 'ninja-forms-elavon-payment-gateway'),
            __('3. TEST your credentials by submitting a form to ensure your credentials', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * Credentials are set, but they have been rejected for authorization
     */
    'credentials supplied in the authorization request are invalid' => array(
        'help_text' => array(
            __('1. Please check your Merchant ID, User ID, or PIN in your settings.', 'ninja-forms-elavon-payment-gateway'),
            __('2. Please check that your credentials are valid for the mode, either -Demo- or -Production- that your are using.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * A WP_Error in which WP could not connect to the endpoint
     */
    'Could not resolve host' => array(
        'help_text' => array(
            __('Explanation: The plugin is functioning correctly, but could not connect to Elavon.', 'ninja-forms-elavon-payment-gateway'),
            __('1. Check that you have a connection to the internet.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * A required field is not included in the request, either by field map
     * omission or the form user did not input a value
     */
    'Required Field Not Supplied' => array(
        'help_text' => array(
            __('Explanation: Your form is not sending required information to Elavon.', 'ninja-forms-elavon-payment-gateway'),
            __('Please check the value was set by doing this:', 'ninja-forms-elavon-payment-gateway'),
            __('1a. Type the word "support" in the Advanced Commands textbox, click Save, then refresh this page.', 'ninja-forms-elavon-payment-gateway'),
            __('1b. Check the Request Array for the missing value.', 'ninja-forms-elavon-payment-gateway'),
            __('If the value is not appearing or is incorrect, check your form design by doing this:', 'ninja-forms-elavon-payment-gateway'),
            __('2. Please ensure your Collect Payment action is sending a value for the field specified.', 'ninja-forms-elavon-payment-gateway'),
            __('3. If the mapped value is from your form, ensure that form users are required to fill it out before submitting.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * Payment amount is not valid, either by not being set in the
     * Collect Payment settings or the valid set is not valid
     */
    'The amount supplied in the authorization request appears to be invalid' => array(
        'help_text' => array(
            __('Explanation: The amount requested to be charged is not a valid amount.', 'ninja-forms-elavon-payment-gateway'),
            __('Here are some step-by-step instructions to help you.  Would you please:', 'ninja-forms-elavon-payment-gateway'),
            __('1. Check that you have set the "Payment Total" in your "Collect Payment" action.', 'ninja-forms-elavon-payment-gateway'),
            __('2. If the total was set, check the value sent by doing this:', 'ninja-forms-elavon-payment-gateway'),
            __('2a. Type the word "support" in the Advanced Commands textbox, click Save, then refresh this page.', 'ninja-forms-elavon-payment-gateway'),
            __('2b. Check the Request Array for the "ssl_amount" value.', 'ninja-forms-elavon-payment-gateway'),
            __('2c. If the value in quotes is not a valid number or is "0.00", check for form design for where total is calculated.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * Invalid Credit Card Number - alert user that card number display of ***
     * is for security, not actual value
     */
    'Credit Card Number supplied in the authorization request appears to be invalid' => array(
        'help_text' => array(
            __('NOTE: The credit card information is not stored or displayed on the settings page for security.', 'ninja-forms-elavon-payment-gateway'),
            __('1. Please ensure your form has a credit card number field', 'ninja-forms-elavon-payment-gateway'),
            __('2. Please check that the credit card number used is valid.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
    /*
     * Invalid Credit Card Date - alert user that card number display of *** is for
     * security, not actual value
     */
    'Credit Card Expiration Date supplied in the authorization request appears to be invalid' => array(
        'help_text' => array(
            __('NOTE: The credit card information is not stored or displayed on the settings page for security.', 'ninja-forms-elavon-payment-gateway'),
            __('1. Please ensure your form has a credit card expiration field', 'ninja-forms-elavon-payment-gateway'),
            __('2. Please check that the credit card expiration entered is a valid date.', 'ninja-forms-elavon-payment-gateway'),
        ),
    ),
        ));
