<?php

if (!defined('ABSPATH'))
    exit;
/**
 * Adds the CRM's settings and settings groups to the main action setting
 * 
 * 
 */
final class NF_Elavon_Admin_Settings {

    /**
     * Consolidated settings data for output
     * @var array 
     */
    protected $supporting_data;

    /**
     * Configured settings for display on settings page
     * 
     * @var array
     */
    protected $configured_settings;

    /**
     * Configures the plugin settings and formats support data
     * 
     */
    public function __construct() {
        // TODO - change this to static function call
        $this->configured_settings = NF_Elavon()->config('PluginSettings');

        $this->collect_data();

        $this->mark_up_settings_data();
     
        $this->support_data_display_logic();

        add_filter('ninja_forms_plugin_settings', array($this, 'plugin_settings'), 10, 1);
        add_filter('ninja_forms_plugin_settings_groups', array($this, 'plugin_settings_groups'), 10, 1);
    }

    /**
     * Merge this action's settings into main settings
     * 
     * @param array $settings
     * @return array
     */
    public function plugin_settings($settings) {

        $settings[NF_Elavon::SLUG] = $this->configured_settings;

        return $settings;
    }

    /**
     * Merge this action's plugin group into settings groups
     * @param array $groups
     * @return array
     */
    public function plugin_settings_groups($groups) {
        // TODO - change this to static function call
        $groups[NF_Elavon::SLUG] = NF_Elavon()->config('PluginSettingsGroups');

        return $groups;
    }

    /**
     * Retrieve data from sources and consolidate for markup
     * 
     * Simplifies iteration of settings output
     */
    protected function collect_data() {

        $support_data = NF_Elavon()->get_support_data();

        $this->settings_data = $support_data;
    }

    /**
     * Uses markup object to markup support data
     */
    protected function mark_up_settings_data() {

        $markup_array = array(
            NF_Elavon_Constants::RESPONSE_SUMMARY,
            NF_Elavon_Constants::REQUEST_ARRAY,
            NF_Elavon_Constants::FULL_RESPONSE,
        );

        $contextual_help = new NF_Elavon_Support();
        
        foreach ($markup_array as $key) {
            $this->configured_settings[$key]['html'] = NF_Elavon_Markup::markup($key, $this->settings_data[$key],$contextual_help);
        }
    }

    
    /**
     * Display or hide support logic based on advanced command
     */
    protected function support_data_display_logic() {

        NF_Elavon_Functions::add_advanced_command_filters('support');

        $support_mode = apply_filters('nfelavon_display_support', false);

        if (!$support_mode) {

            $support_mode_settings = array(
//                NF_Elavon_Constants::FIELD_MAP_DATA, // unused
                NF_Elavon_Constants::REQUEST_ARRAY,
//                NF_Elavon_Constants::FORMATTED_REQUEST, // unused
                NF_Elavon_Constants::FULL_RESPONSE,
            );

            foreach ($support_mode_settings as $setting) {

                unset($this->configured_settings[$setting]);
            }
        }
    }

    /**
     * Returns the listener link to test the API
     */
    protected function api_test_link() {

        $url = home_url() . '/?' . NF_Elavon_Constants::LISTENER_URL . '=' . NF_Elavon_Constants::CONNECTION_TEST;
        $link = '<a id="elavon-connection-test" href="' . $url . '" class = "button">Click to test your API connection</a>';

        $this->configured_settings[NF_Elavon_Constants::CONNECTION_VERIFICATION]['html'] = $link;
    }


}

// End Class


